import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/repo/home/home_repo.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/custom_loader/custom_loader.dart';
import 'package:viser_remit/view/components/will_pop_widget.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/currency_section.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/dashboard_card_section.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/header_section.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/kyc_warning_section.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/recent_section.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/util.dart';

class HomeScreen extends StatefulWidget {
  const HomeScreen({Key? key}) : super(key: key);

  @override
  State<HomeScreen> createState() => _HomeScreenState();
}

class _HomeScreenState extends State<HomeScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(HomeRepo(apiClient: Get.find()));
    final controller = Get.put(HomeController(homeRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      // controller.loadCountryData();
      controller.loadAllData(fromHome: true);
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
      builder: (controller) {
        return WillPopWidget(
          nextRoute: "",
          child: Scaffold(
            backgroundColor: MyColor.primaryColor.withOpacity(.02),
            body: Stack(
              children: [
                HeaderSection(controller: controller),
                if (controller.isLoading)
                  Container(
                    margin: const EdgeInsetsDirectional.only(top: 90, bottom: Dimensions.space10, start: Dimensions.space15, end: Dimensions.space15),
                    width: double.infinity,
                    decoration: BoxDecoration(
                      color: Colors.white,
                      boxShadow: MyUtils.getCardShadow(),
                      borderRadius: const BorderRadius.all(
                        Radius.circular(12),
                      ),
                    ),
                    child: const Center(
                      child: CustomLoader(),
                    ),
                  )
                else
                  Padding(
                    padding: const EdgeInsetsDirectional.only(top: 90),
                    child: RefreshIndicator(
                      color: MyColor.primaryColor,
                      onRefresh: () async {
                        controller.loadAllData(fromHome: true);
                      },
                      child: SingleChildScrollView(
                        physics: const BouncingScrollPhysics(),
                        child: Stack(
                          children: [
                            if (controller.isLoading)
                              const CustomLoader()
                            else ...[
                              Padding(
                                padding: const EdgeInsetsDirectional.only(start: Dimensions.space5, end: Dimensions.space5),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    //Currency Select Card
                                    const CurrencySection(),
                                    Container(
                                      margin: const EdgeInsetsDirectional.only(top: Dimensions.space10, bottom: Dimensions.space10, start: Dimensions.space8, end: Dimensions.space8),
                                      width: double.infinity,
                                      decoration: BoxDecoration(
                                        boxShadow: MyUtils.getCardShadow(),
                                        borderRadius: const BorderRadius.all(
                                          Radius.circular(12),
                                        ),
                                      ),
                                      child: Column(
                                        children: [
                                          KYCWarningSection(controller: controller),
                                          DashBoardCardSection(controller: controller),
                                          Container(
                                            height: Dimensions.space10,
                                            color: MyColor.transparentColor,
                                          ),
                                          RecentSection(controller: controller),
                                        ],
                                      ),
                                    )
                                  ],
                                ),
                              ),
                            ]
                          ],
                        ),
                      ),
                    ),
                  ),
              ],
            ),
          ),
        );
      },
    );
  }
}
